import java.lang.Math;
import java.security.PublicKey;

public class Vector {
    public Vector(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float x;
    public float y;

	public float getDistance( Vector v2 ) {
		return (float) Math.sqrt( ( Math.pow(v2.x - x, 2) + Math.pow(v2.y - y, 2) ) );
	
		//sqrt( pow(x2-x1) + pow(y2-y1) )
	}

    public Vector add( Vector v2 ) {
        x += v2.x;
        y += v2.y;
        return this;
    }

    public Vector add( Vector a, Vector b ) {
        return new Vector( (a.x + b.x) , (a.y + b.y) );

    }

    public Vector subtract( Vector v2 ) {
        x -= v2.x;
        y -= v2.y;
        return this;
    }

    public Vector subtract( Vector a, Vector b ) {
        return new Vector( (a.x - b.x) , (a.y - b.y) );
    }

    public Vector multiply( float c ) {
        x *= c;
        y *= c;
        return this;
    }

    public Vector multiply( Vector a, float c ) {
        return new Vector( (a.x * c), (a.y * c) );

    }

    public Vector divide( float c ) {
        x /= c;
        y /= c;
        return this;
    }

    public float vectorToAngle() {
        return (float) Math.atan2( (double) y, (double) x );

    }

    public float vectorToAngle( Vector v1 ) {
        return (float) Math.atan2( (double) v1.y, (double) v1.x );

    }

    public float square() {
        return (x*x) + (y*y);

    }

    public float length() {
        return (float) Math.sqrt( square() );
    }

    public Vector normalize() {
        return this.divide( this.length() );
    }

}



	
